/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of application main dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------

    2006-06-28  initial version

**************************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxTestDlg.h
///  Definition file of application main dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "PacketDlg.h"
#include "IOAccessDlg.h"
#include "InformationDialog.h"
#include "WatchdogDlg.h"
#include "HostStateDlg.h"
#include "BusStateDlg.h"
#include "DMAStateDlg.h"
#include "DownloadDlg.h"
#include "MailboxStateDlg.h"
#include "ResetDlg.h"
#include "ConfigLockDlg.h"
#include "FileExplorerDlg.h"
#include "ConnectorDlg.h"
#include "cifXAPIlib.h"

//forward declaration
class CCifXDeviceBase;
class CBaseDialog;

///////////////////////////////////////////////////////////////////////////////////////////
/// Main cifX Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CcifXTestDlg : public CDialog
{
public:
	CcifXTestDlg(CWnd* pParent = NULL);

	enum { IDD = IDD_CIFXTEST_DIALOG };

  static CCifXDeviceBase*  s_pcDevice;    //!< static member containing the actually selected device

  CCifXAPIlib*  GetSelectedAPI( void);
  void          SetSelectedAPI( CCifXAPIlib* pcAPI);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV-Untersttzung

protected:

  HICON             m_hIcon;
  
  CStatusBar        m_cStatusBar;   //!< Statusbar (1 Pane)

  CBaseDialog*        m_pcActualDlg;      //!< Pointer to the currently active dialog
  CPacketDlg          m_cPacketDlg;       //!< Packet dialog instance
  CIOAccessDlg        m_cIoDlg;           //!< IO Data dialog instance
  CInformationDialog  m_cInfoDialog;      //!< Generic Information dialog
  CWatchdogDlg        m_cWatchdogDlg;     //!< Watchdog trigger dialog
  CHostStateDlg       m_cHostStateDlg;    //!< Host state set/get dialog
  CBusStateDlg        m_cBusStateDlg;     //!< Bus state set/get dialog
  CDMAStateDlg        m_cDMAStateDlg;     //!< Bus state set/get dialog
  CDownloadDlg        m_cDownloadDlg;     //!< Download Dialog
  CMailboxStateDlg    m_cMailboxStateDlg; //!< Show actual Mailbox state dialog
  CResetDlg           m_cResetDlg;        //!< Device Reset dialog
  CConfigLockDlg      m_cConfigLockDlg;   //!< Device configuration Lock dialog
  CFileExplorerDlg    m_cFileExplorerDlg; //!< File Explorer dialog
  CCifXAPIlib         m_cCifXAPICIFX;
  CCifXAPIlib         m_cCifXAPInetXTransport;
  CCifXAPIlib         m_cCifXAPInetXSPM;

  virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL PreTranslateMessage(MSG* pMsg);
  afx_msg void OnFileQuit();
  afx_msg void OnDestroy();
  afx_msg void OnDeviceOpen();
  void OnInitMenuPopup(CMenu *pPopupMenu, UINT nIndex,BOOL bSysMenu);
  afx_msg void OnUpdateDeviceClose(CCmdUI *pCmdUI);
  afx_msg void OnUpdateDeviceReset(CCmdUI *pCmdUI);
  afx_msg void OnUpdateDeviceWatchdog(CCmdUI *pCmdUI);
  afx_msg void OnUpdateDatatransferPacketdata(CCmdUI *pCmdUI);
  afx_msg void OnUpdateDatatransferI(CCmdUI *pCmdUI);
  afx_msg void OnDeviceClose();
  afx_msg void OnDatatransferPacketdata();
  afx_msg void OnDatatransferI();

  void SetActiveDialog(CBaseDialog* pcNewDialog);

  afx_msg void OnHelpAbout();
  afx_msg void OnInformationDriverinformation();
  afx_msg void OnUpdateInformationChannelinformation(CCmdUI *pCmdUI);
  afx_msg void OnInformationChannelinformation();
  afx_msg void OnDeviceWatchdog();
  afx_msg void OnDeviceHoststate();
  afx_msg void OnUpdateDeviceHoststate(CCmdUI *pCmdUI);
  afx_msg void OnDeviceBusstate();
  afx_msg void OnUpdateDeviceBusstate(CCmdUI *pCmdUI);
  afx_msg void OnDeviceDMAstate();
  afx_msg void OnUpdateDeviceDMAstate(CCmdUI *pCmdUI);
  afx_msg void OnDeviceDownload();
  afx_msg void OnUpdateDeviceDownload(CCmdUI *pCmdUI);
  afx_msg void OnInformationMailboxstate();
  afx_msg void OnUpdateInformationMailboxstate(CCmdUI *pCmdUI);
  afx_msg void OnDeviceReset();
  afx_msg void OnUpdateDeviceOpen(CCmdUI *pCmdUI);
  afx_msg void OnUpdateInformationDriverinformation(CCmdUI *pCmdUI);
  afx_msg void OnUpdateDeviceConfiglock(CCmdUI *pCmdUI);
  afx_msg void OnDeviceConfiglock();
  afx_msg void OnDeviceFileexplorer();
  afx_msg void OnUpdateDeviceFileexplorer(CCmdUI *pCmdUI);

  afx_msg void OnRemotedevicesSetup();
  afx_msg void OnUpdateRemotedevicesSetup(CCmdUI *pCmdUI);

  afx_msg void OnCIFXSelect();
  afx_msg void OnUpdateCIFXSelect(CCmdUI *pCmdUI);
  afx_msg void OnNetXTransportSelect();
  afx_msg void OnUpdateNetXTransportSelect(CCmdUI *pCmdUI);
  afx_msg void OnNetXSPMSelect();
  afx_msg void OnUpdateNetXSPMSelect(CCmdUI *pCmdUI);
};
